set terminal pngcairo enhanced font "Times New Roman,14" size 1200,600
set encoding utf8
set xtics 2
set grid

#Iz vhodnih argumentov sestavi ime datoteke za izris in ime izhodne datoteke
iPostaja = substr(ARG1,0,4)
fIme = ".\\3Obdelava\\".ARG2."\\".ARG1."_".ARG2."_".ARG3."_".ARG4
fPodatki = fIme.".txt"
fRezultati = fIme.".png"

set output fRezultati

set multiplot
set size 1,0.36
set origin 0,0
set lmargin at screen 0.1
set xlabel "{\304\214}as [ura]"
set ylabel "{/Symbol D}h [cm]"
set ytics 10
set yrange [-30:30]
plot fPodatki u ($2/3600):($23*100) with points pt 7 lt rgb "red" ps 1 notitle

unset xlabel
set xtics format ''
set size 1,0.36
set origin 0,0.33
set lmargin at screen 0.1
set ylabel "{/Symbol D}e [cm]"
set ytics 2
set yrange [-10:10]
plot fPodatki u ($2/3600):($22*100) with points pt 7 lt rgb "green" ps 1 notitle

set size 1,0.36
set origin 0,0.66
set lmargin at screen 0.1
set ylabel "{/Symbol D}n [cm]"
set ytics 2
set yrange [-10:10]
set title "Postaja GNSS: ".iPostaja." [".ARG2."-".ARG3."-".ARG4."]" offset 0,-1
plot fPodatki u ($2/3600):($21*100)  with points pt 7 lt rgb "blue" ps 1 notitle

unset multiplot
