%Izravnava prostorske podobnostne transformacije:
% Podatki so: Koordinate tock v dveh sistemih (A in B)

clear all;
clc;

%Nalozi opazovanja:
Opazovanja;

%Nastavi osnovne matrike izravnave:
A = zeros(c,n);
B = zeros(c,u);
f = zeros(c,1);
S = zeros(n,n);

%Nastavi faktor za neznanke:
fW = 180/pi*3600;
fM = 1e6;

%Nastavi priblizne vrednosti neznank:
T0 = zeros(3,1); %trije premiki
W0 = zeros(3,1); %trije zasuki
m0 = 1;          %eno merilo

fprintf('PARAMETRI SPLOSNEGA MODELA IZRAVNAVE:\n\n');

fprintf('  Stevilo tock                    k : %10d\n',k)
fprintf('  Stevilo opazovanj(koordinat)    n : %10d\n',n)
fprintf('  Stevilo neznank (tr. parametri) u : %10d\n',u)
fprintf('  Minimalno stevilo opazovanj     n0: %10d\n',n0)
fprintf('  Stevilo nadstevilnih opazovanj  r : %10d\n',r)
fprintf('  Stevilo sestavljenih enacb      c : %10d\n\n',c)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% SPLOSNI MODEL IZRAVNAVE PO MNK - IZRACUN RESITVE PROSTORSKE TRANSFORMACIJE
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

prag = 1;
nIter = 0;
fprintf('IZRAVNAVA PO MNK - SPLOSNI MODEL IZRAVNAVE [ITERACIJSKI POSTOPEK]:\n\n');
%while prag>1e-6

	%nastavi rotacijske matrike:
	RX0 = RotM(W0(1),'x');
	RY0 = RotM(W0(2),'y');
	RZ0 = RotM(W0(3),'z');
	R0  = RX0*RY0*RZ0;

	dRX0 = dRotM(W0(1),'x');
	dRY0 = dRotM(W0(2),'y');
	dRZ0 = dRotM(W0(3),'z');

    %Sestava enacb in linearizacija za vsako tocko posebej:
    for i=1:k
        %koordinate i-te tocke v obeh sistemih:
        XA = XYZA(i,1:3)';
        XB = XYZB(i,1:3)';

        %natancnosti koordinat i-te tocke v obeh sistemih
        sXA = XYZA(i,4:6) / 1000;
        sXB = XYZB(i,4:6) / 1000;

        %Enacba transformacije (vektorsko):
        Fi = T0 + m0*R0*XA - XB;

        %Linearizacija - sestava  matrike Ai (parcialni odvodi po opazovanjih)
        Fi_XA = m0*R0;
        Fi_XB = -eye(3);

        Ai = [Fi_XA  Fi_XB];

        %Linearizacija - sestava matrike Bi (parcialni odvodi po neznankah)
        Fi_T  = eye(3);
        Fi_wx = m0 * dRX0 *  RY0 *  RZ0 * XA;% / fW;
        Fi_wy = m0 *  RX0 * dRY0 *  RZ0 * XA;% / fW;
        Fi_wz = m0 *  RX0 *  RY0 * dRZ0 * XA;% / fW;
        Fi_m  = R0*XA                       ;% / fM;

        Bi = [Fi_T  Fi_wx Fi_wy Fi_wz   Fi_m];

        %Linearizacija - sestava fi (vektor odstopanj)
        fi = -Fi;

        %Stohasticni model:
        Si = diag( [sXA sXB].^2 );

        %Polnenje matrika A, B, f in S
        A(3*i-2:3*i, 6*i-5:6*i) = Ai;
        B(3*i-2:3*i,      :   ) = Bi;
        f(3*i-2:3*i)            = fi;
        S(6*i-5:6*i, 6*i-5:6*i) = Si;

    end

  %Resitev splosnega modela izravnave po MNK
	rVar0 = mean(diag(S));
	Q = S/rVar0;
	P = inv(Q);

	Qe = A*Q*A';
	Pe = inv(Qe);

%	N = B'*Pe*B;
%	t = B'*Pe*f;

%	Qxx = inv(N);
%	dX = Qxx*t;
%	prag = norm(dX);

	%Popravi priblizne vrednosti neznank:
%	T0 = T0 + dX(1:3);
%	W0 = W0 + dX(4:6)/fW;
%	m0 = m0 + dX(7)/fM;

	nIter = nIter + 1;


%	fprintf('  Iteracija: %2d [%10.2e]\n',nIter,prag);
%	if nIter > 20
%		disp('\n\t\t ********************************\n\n');
%		break;
%	end

%end
%fprintf('\n');

% %Izracun popravkov opazovanj, referencne variance a-posteriori in globalnega testa
% v = Q*A'*Pe*(f-B*dX);
% rVarI = v'*P*v/r;
% gTest = rVarI / rVar0;
% %izvedite globalni test glede na hi-kvadrat porazdelitev!!
% 
% %Izpis rezultatov
% fprintf('GLOBALNI TEST MODELA:\n\n');
% 
% fprintf('  Ref. varianca a-priori    :  %10.4e [SQRT: %7.4f] \n',rVar0,sqrt(rVar0));
% fprintf('  Ref. varianca a-posteriori:  %10.4e [SQRT: %7.4f] \n',rVarI,sqrt(rVarI));
% fprintf('  Globalni test             :  %10.2f [SQRT: %7.2f] \n\n\n',gTest,sqrt(gTest));
% 
% fprintf('REZULTATI IZRAVNAVE:\n\n');
% 
% fprintf(' OCENJENI TRANSFORMACIJSKI PARAMETRI IN NJIHOVE NATANCNOSTI:\n\n');
% 
% fprintf('  TX   %12.4f m  +- %8.2f m\n',T0(1), sqrt(rVarI*Qxx(1,1)) );
% fprintf('  TY   %12.4f m  +- %8.2f m\n',T0(2), sqrt(rVarI*Qxx(2,2)) );
% fprintf('  TZ   %12.4f m  +- %8.2f m\n',T0(3), sqrt(rVarI*Qxx(3,3)) );
% 
% fprintf('  WX   %12.4f '''' +- %8.2f ''''\n',rad2sec(W0(1)), sqrt(rVarI*Qxx(4,4)) );
% fprintf('  WY   %12.4f '''' +- %8.2f ''''\n',rad2sec(W0(2)), sqrt(rVarI*Qxx(5,5)) );
% fprintf('  WZ   %12.4f '''' +- %8.2f ''''\n',rad2sec(W0(3)), sqrt(rVarI*Qxx(6,6)) );
% 
% fprintf('   M   %12.10f    +- %8.2f ppm\n\n',m0, sqrt(rVarI*Qxx(7,7)) );
% 
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% %% SKLADNOST KOORDINATNIH SISTEMOV - RAZLIKA GEOMETRIJE OBEH KOORDINATNIH SISTEMOV
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
% fprintf(' RAZLIKE MED GEOMETRIJAMA OBEH SISTEMOV: XB - TRANSFORMIRAJ(XA):\n\n');
% 
% fprintf('  TOCKA     DX[mm]   DY[mm]   DZ[mm]\n');
% fprintf('  ----------------------------------\n');
% Y = 0; %statistika skladnosti koordinatnih sistemov
% for i=1:k
%   %polozaja tocke v sistemu A in B
%   XAi = XYZA(i,1:3)';   SXAi = diag( (XYZA(i,4:6)/1000).^2);
%   XBi = XYZB(i,1:3)';   SXBi = diag( (XYZB(i,4:6)/1000).^2);
% 
%   %transformacija polozaja tocke iz sistema A v sistem B
%   XAti = T0 + m0*R0*XAi;
% 
%   %izpis rezultatov na ekran
%   fprintf('   %s  %8.1f %8.1f %8.1f\n',TC{i},(XBi-XAti)*1000);
% 
%   %Izracun statistike Y - dodamo za vsako tocko posebej
%   Y = Y + (XBi-XAti)'*inv(SXAi+SXBi)*(XBi-XAti);
% end
% fprintf('  ----------------------------------\n\n');
% 
% fprintf(' SKLADNOST KOORDINATNIH SISTEMOV: \n\n');
% fprintf('  Statistika Y = %8.2f\n\n',Y)