clearvars; clc; format long g;

%---------------------------------------------------%
% Posredna izravava GNSS štirikotnika na strehi FGG %
%---------------------------------------------------%


% naložimo podatke iz datoteke podatki.m (dXi, dYi, dZi, P, Q, var_apriori)
podatki;    

% 0. PARAMETRI IZRAVNAVE
% število opazovanj                                       : n      = ? * ? komponente baznega vektorja = ?
% število neznank / minimalno število potrebnih opazovanj : u = n0 = ? * ? koordinatne komponente      = ?
% število nadštevilnih opazovanj                          : r      = ? - ?                             = ?
n  = ;
n0 = ;
u  = ;
r  = ;


% 1. NASTAVIMO VEKTOR OPAZOVANJ l (dimenzije n x 1)
l = [];


% 2. NASTAVIMO PRIBLIŽNE VREDNOSTI u NEZNANK IN VEKTOR PRIBLIŽNIH VREDNOSTI NEZNANK x0 (dimenzije u x 1)
% Ker je matematični model izravnave linearen, lahko teoretično za približne vrednosti neznank vzamemo vrednost 0.
% Za lažje iskanje morebitnih napak v enačbah popravkov opazovanj je priporočljivo vzeti prave/dobre približne vrednosti neznank.
X0_FGG1 = ;    % X1
Y0_FGG1 = ;    % Y1
Z0_FGG1 = ;    % Z1
X0_FGG2 = ;    % X2
Y0_FGG2 = ;    % Y2
Z0_FGG2 = ;    % Z2
X0_FGG4 = ;    % X3
Y0_FGG4 = ;    % Y3
Z0_FGG4 = ;    % Z3

x0 = [];    % vrstni red točk naj bo FGG1, FGG2, FGG4

% 3. NASTAVIMO MATRIKO B - odvodi enačb popravkov opazovanj po neznankah (dimenzije n x u)
%    --> v skladu z vrstnim redom neznank v vektorju x0

%       ∂Fi       ∂Fi       ∂Fi       ∂Fi       ∂Fi       ∂Fi       ∂Fi       ∂Fi       ∂Fi  
%    --------  --------  --------  --------  --------  --------  --------  --------  --------
%    ∂ΔX_????  ∂ΔY_????  ∂ΔZ_????  ∂ΔX_????  ∂ΔY_????  ∂ΔZ_????  ∂ΔX_????  ∂ΔY_????  ∂ΔZ_????
B = [                                                                                                 % ΔX: ????-????
                                                                                                      % ΔY: ????-????
                                                                                                      % ΔZ: ????-????

                                                                                                      % ΔX: ????-????
                                                                                                      % ΔY: ????-????
                                                                                                      % ΔZ: ????-????

                                                                                                      % ΔX: ????-????
                                                                                                      % ΔY: ????-????
                                                                                                      % ΔZ: ????-????

                                                                                                      % ΔX: ????-????
                                                                                                      % ΔY: ????-????
                                                                                                      % ΔZ: ????-????

                                                                                                      % ΔX: ????-????
                                                                                                      % ΔY: ????-????
                                                                                                      % ΔZ: ????-????

                                                                                                      % ΔX: ????-????
                                                                                                      % ΔY: ????-????
                                                                                             ];       % ΔZ: ????-????


% 4. NASTAVIMO VEKTOR ODSTOPANJ f (dimenzije n x 1)
f(1,1) = ;
f(2,1) = ;
f(3,1) = ;

f(4,1) = ;
f(5,1) = ;
f(6,1) = ;

f(7,1) = ;
f(8,1) = ;
f(9,1) = ;
 
f(10,1) = ;
f(11,1) = ;
f(12,1) = ;

f(13,1) = ;
f(14,1) = ;
f(15,1) = ;

f(16,1) = ;
f(17,1) = ;
f(18,1) = ;


% 5. REŠIMO FUNKCIONALNI MODEL POSREDNE IZRAVNAVE PO MNK
N = ;
t = ;
delta = ;
v = ;
l_izr = ;

% Izračun 3D-kartezičnih koordinat novih točk
x_izr = ;                  % vektor izravnanih vrednosti neznank
FGG1 = x_izr(?:?)';        % vektor koordinat nove točke FGG1 (XFGG1, YFGG1, ZFGG1)
FGG2 = x_izr(?:?)';        % vektor koordinat nove točke FGG2 (XFGG2, YFGG2, ZFGG2)
FGG4 = x_izr(?:?)';        % vektor koordinat nove točke FGG3 (XFGG4, YFGG4, ZFGG4)
nove_tocke_koordinate_XYZ = [????; ????; ????];    % matrika koordinat novih točk (vsaka točka en stolpec)
nove_tocke_imena = ["????"; "????"; "????"];       % vektor imen novih točk


% 6. REŠIMO STOHASTIČNI MODEL POSREDNE IZRAVNAVE PO MNK
var0_aposteriori = ;    % referenčna varianca a-posteriori
Q_delta_delta = ;       % matrika kofaktorjev popravkov približnih vrednosti neznank
Q_xi_xi = ;             % matrika kofaktorjev neznank
Q_vv = ;                % matrika kofaktorjev popravkov opazovanj
Q_li_li = ;             % matrika kofaktorjev izravnanih opazoavanj


% Ker obravnavamo GNSS mrežo uporabimo referenčno varianco a-posteriori kljub morebiti zavrnjenemu globalnemu testu.
% V poročilu obrazloži zakaj in pod kakšnim pogojem.
Sigma_vv = ;
Sigma_li_li = ;
Sigma_delta_delta = ;
Sigma_xi_xi = ;

sX_FGG1_izr = ;
sY_FGG1_izr = ;
sZ_FGG1_izr = ;

sX_FGG2_izr = ;
sY_FGG2_izr = ;
sZ_FGG2_izr = ;

sX_FGG4_izr = ;
sY_FGG4_izr = ;
sZ_FGG4_izr = ;


% 7. GLOBALNI TEST MODELA
% Pri stopnji značilnosti testa α = 5 % mora veljati: 0,6 < Y < 1,6, da skladnosti referenčne variance a-priori in
% a-posteriori ne moremo ovreči (dana je groba ocena spodnje in zgornje meje za α = 5 % - za točen izračun zgornje in
% spodnje meje glej dokument s pomočjo).
alphaG = ;
spodnja_meja_Y = chi2inv(??, ??) / ??;
zgornja_meja_Y = chi2inv(??, ??) / ??;
Y = ;


% 8. ZA POSAMEZNE KOMPONENTE BAZNIH VEKTORJEV NAREDIMO TAU-TEST
sv_dX1 = ;
sv_dY1 = ;
sv_dZ1 = ;
      
sv_dX2 = ;
sv_dY2 = ;
sv_dZ2 = ;
      
sv_dX3 = ;
sv_dY3 = ;
sv_dZ3 = ;
      
sv_dX4 = ;
sv_dY4 = ;
sv_dZ4 = ;
      
sv_dX5 = ;
sv_dY5 = ;
sv_dZ5 = ;
      
sv_dX6 = ;
sv_dY6 = ;
sv_dZ6 = ;

v_dX1 = ;
v_dY1 = ;
v_dZ1 = ;

v_dX2 = ;
v_dY2 = ;
v_dZ2 = ;

v_dX3 = ;
v_dY3 = ;
v_dZ3 = ;

v_dX4 = ;
v_dY4 = ;
v_dZ4 = ;

v_dX5 = ;
v_dY5 = ;
v_dZ5 = ;

v_dX6 = ;
v_dY6 = ;
v_dZ6 = ;


% Izračun empirične vrednost tau: Ti = vi / svi
% Veljati mora (za α = 5 %): |Ti| < 1,90 -> opazovanje ni grobo pogrešeno (dana je groba ocena spodnje in zgornje meje)
% točen izračun za stopnjo značilnosti testa α = 5 % in število prostostnih stopenj (r-1) -> glej dokument s pomočjo).
alphaT = 0.05;
zgornja_meja_T = sqrt(??) * tinv(??, ??) / sqrt(?? - 1 + tinv(??, ??)^2);
spodnja_meja_T = -spodnja_meja_T;

T_dx1 = ;
T_dy1 = ;
T_dz1 = ;

T_dx2 = ;
T_dy2 = ;
T_dz2 = ;

T_dx3 = ;
T_dy3 = ;
T_dz3 = ;

T_dx4 = ;
T_dy4 = ;
T_dz4 = ;

T_dx5 = ;
T_dy5 = ;
T_dz5 = ;

T_dx6 = ;
T_dy6 = ;
T_dz6 = ;

T = [T_dx1, T_dy1, T_dz1, T_dx2, T_dy2, T_dz2, T_dx3, T_dy3, T_dz3, ...
     T_dx4, T_dy4, T_dz4, T_dx5, T_dy5, T_dz5, T_dx6, T_dy6, T_dz6]';


% 9. IZPIS
hline   = repmat('-', 1, 80);
hline_d = repmat('=', 1, 80);
fprintf('%s\n', hline_d);
fprintf('============================== POSREDNA IZRAVNAVA ==============================\n');
fprintf('%s\n\n', hline_d);
fprintf('------------------------------ PARAMETRI IZRAVNAVE -----------------------------\n');
fprintf('n  = %2d\n', n);
fprintf('n0 = %2d\n', n0);
fprintf('u  = %2d\n', n0);
fprintf('r  = %2d\n', r);
fprintf('\n');

fprintf('------------------------------ IZRAVNANA OPAZOVANJA ----------------------------\n');
fprintf('       l      +       v      =      v_izr   +-   σv_izr    \n')
fprintf('      [m]            [m]             [m]          [m]\n')
for i = 1 : length(v)
    fprintf('%11.5f   + %10.5f   = %11.5f  +- %8.5f\n', ...
        l(i), v(i), l_izr(i), sqrt(Sigma_li_li(i,i)));
end
fprintf('\n');

fprintf('----------------------------- GLOBALNI TEST MODELA -----------------------------\n');
fprintf('var0      = %12.8f m2\n', var0_apriori);
fprintf('var0_izr  = %12.8f m2\n', var0_aposteriori);
    if (spodnja_meja_Y < Y) && (Y < zgornja_meja_T)
        flag = "";
        trditev = sprintf("\nS tveganjem %.1f %%%% ne moremo trditi, da sta referenčni " + ...
            "varianci\na-posteriori in a-priori statistično značilno različni.\n", alphaG*100);
    else
        flag = "***";
        trditev = sprintf("\nS tveganjem %.1f %%%% lahko trditmo, da sta referenčni " + ...
            "varianci\na-posteriori in a-priori statistično značilno različni.\n", alphaG*100);
    end
fprintf('Y         = %6.2f  %s\n', Y, flag);
fprintf('Y_sp_meja = %6.2f\n', spodnja_meja_Y);
fprintf('Y_zg_meja = %6.2f\n', zgornja_meja_Y);
fprintf(trditev);
fprintf('\n');

fprintf('----------------------------------- TAU-TEST -----------------------------------\n');
fprintf('α      = %.2f %%\n', alphaT*100);
fprintf('T_krit = %.4f\n', zgornja_meja_T);
fprintf('\n');
fprintf('    v          σv         Tv \n');
fprintf('   [mm]       [mm]           \n');
fprintf('-----------------------------\n');
for i = 1 : length(v)
    if abs(T(i)) > zgornja_meja_T
        flag = "***";
    else
        flag = "";
    end
    fprintf('%7.2f    %7.2f    %7.2f  %s\n', ...
        v(i)*1000, sqrt(Sigma_vv(i,i))*1000, abs(T(i)), flag);
end
fprintf('\n');

fprintf('----------------------- OCENJENE KOORDINATE V D96-17/XYZ -----------------------\n');
for i = 1 : size(nove_tocke_koordinate_XYZ, 1)
	fprintf('%s    X   %14.4f m      σX   %4.1f mm\n', ...
        nove_tocke_imena(i), nove_tocke_koordinate_XYZ(i, 1), sqrt(Sigma_xi_xi(3*i-2, 3*i-2))*1e3);
    fprintf('        Y   %14.4f m      σY   %4.1f mm\n', ...
        nove_tocke_koordinate_XYZ(i, 2), sqrt(Sigma_xi_xi(3*i-1, 3*i-1))*1000);
    fprintf('        Z   %14.4f m      σZ   %4.1f mm\n', ...
        nove_tocke_koordinate_XYZ(i, 3), sqrt(Sigma_xi_xi(3*i,   3*i))*1000);
    fprintf('\n')
end

fprintf('%s\n', hline_d);
